/*****************************************************************************
*  LPC11U6x SCT demo program
*
*  Use the match reload registers to change the duty cycle of two PWM
*  signals and maintain their dead-time intervals using the NORELOAD_L bit
*  in the SCT Configuration register
*****************************************************************************/
#include "nxp_lpc11u6x.h"

extern void SCT1_Init(void);

#define hperiod    (180)

void SysTick_Handler(void)
{
    LPC_SCT1->CONFIG |= (1 << 7);                      // stop reload process for L counter

    if (LPC_GPIO_PORT->PIN[0] & (1 << 3))              // P0_3 high?
    {
        if (LPC_SCT1->MATCHREL[2].L < hperiod-1)       // check if DC2 < Period of PWM
        {
            LPC_SCT1->MATCHREL[1].L ++;
            LPC_SCT1->MATCHREL[2].L ++;
        }
    }
    else if (LPC_SCT1->MATCHREL[1].L > 1)              // check if DC1 > 1
    {
        LPC_SCT1->MATCHREL[1].L --;
        LPC_SCT1->MATCHREL[2].L --;
    }
    LPC_SCT1->CONFIG &= ~(1 << 7);                     // enable reload process for L counter
}

int main (void)
{
    LPC_SYSCON->SYSAHBCLKCTRL |= (1u << 16)            // enable clock for IOCON
                               | (1u << 31);           // enable clock for SCT0/1

    LPC_IOCON->PIO2_16 = 0x00000081;                   // P2_16 is SCT1_OUT0
    LPC_IOCON->PIO2_17 = 0x00000081;                   // P2_17 is SCT1_OUT1

    SysTick_Config(SystemCoreClock/50);                // SysTick interrupt @ 50 Hz = 20 msec
    SCT1_Init();                                       // Initialize SCT1

    while (1)                                          // loop forever
    {
    }
}
